/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <sys/types.h>
#include "udm_config.h"
#include "udm_uniconv.h"

int udm_mb_wc_8bit(UDM_CONV *conv, UDM_CHARSET *cs,int *wc,
		   const unsigned char *str,
		   const unsigned char *end)
{
	*wc=cs->tab_to_uni[*str];
	return (!wc[0] && str[0]) ? UDM_CHARSET_ILSEQ : 1;
}

int udm_wc_mb_8bit(UDM_CONV *conv, UDM_CHARSET *cs, int *wc, unsigned char *s, unsigned char *e)
{
	UDM_UNI_IDX *idx;
	
	for(idx=cs->tab_from_uni; idx->tab ; idx++){
		if(idx->from <= *wc && idx->to >= *wc){
			s[0]=idx->tab[*wc - idx->from];
			return (!s[0] && *wc) ? UDM_CHARSET_ILUNI : 1;
		}
	}
	return UDM_CHARSET_ILUNI;
}
